-- Script MySQL - Despesas por Órgão e Função

CREATE DATABASE IF NOT EXISTS consorcio_abc;
USE consorcio_abc;

CREATE TABLE IF NOT EXISTS despesas_orgao_funcao (
    id INT AUTO_INCREMENT PRIMARY KEY,
    orgao VARCHAR(100) NOT NULL,
    funcao VARCHAR(100) NOT NULL,
    valor DECIMAL(15,2) NOT NULL
);

INSERT INTO despesas_orgao_funcao (orgao, funcao, valor) VALUES
('CONSÓRCIO INTERMUNICIPAL GRANDE ABC', 'Administração', 6462330.84),
('CONSÓRCIO INTERMUNICIPAL GRANDE ABC', 'Assistência Social', 1651515.08),
('CONSÓRCIO INTERMUNICIPAL GRANDE ABC', 'Saúde', 0.00),
('CONSÓRCIO INTERMUNICIPAL GRANDE ABC', 'Trabalho', 0.00),
('CONSÓRCIO INTERMUNICIPAL GRANDE ABC', 'Direitos da Cidadania', 220000.00),
('CONSÓRCIO INTERMUNICIPAL GRANDE ABC', 'Gestão Ambiental', 5120363.21);

-- Consulta total por órgão
SELECT orgao, FORMAT(SUM(valor), 2, 'pt_BR') AS total_despesas
FROM despesas_orgao_funcao
GROUP BY orgao;

-- Consulta total geral
SELECT FORMAT(SUM(valor), 2, 'pt_BR') AS total_geral
FROM despesas_orgao_funcao;
